/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.extended_sliding_doors;

import com.railwayteam.railways.registry.CRIcons;
import com.simibubi.create.content.curiosities.deco.SlidingDoorBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public enum SlidingDoorMode implements INamedIconOptions
{
    AUTO(CRIcons.I_DOOR_AUTO),
    MANUAL(CRIcons.I_DOOR_MANUAL),
    STATION_RIGHT(CRIcons.I_DOOR_STATION_RIGHT, true),
    STATION_LEFT(CRIcons.I_DOOR_STATION_LEFT, true);

    private final String translationKey;
    private final AllIcons icon;
    public final boolean stationBased;

    private SlidingDoorMode(AllIcons icon) {
        this(icon, false);
    }

    private SlidingDoorMode(AllIcons icon, boolean stationBased) {
        this.icon = icon;
        this.translationKey = "sliding_door.mode." + Lang.asId((String)this.name());
        this.stationBased = stationBased;
    }

    public SlidingDoorMode flipped() {
        if (this.stationBased) {
            return this == STATION_LEFT ? STATION_RIGHT : STATION_LEFT;
        }
        return this;
    }

    public AllIcons getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public static SlidingDoorMode fromNbt(CompoundTag nbt) {
        if (nbt == null) {
            return AUTO;
        }
        return SlidingDoorMode.values()[Math.min(3, Math.max(0, nbt.m_128451_("ScrollValue")))];
    }

    public static interface IHasDoorMode {
        public SlidingDoorMode getSlidingDoorMode();
    }

    public static class SlidingDoorValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public SlidingDoorValueBoxTransform() {
            super((state, d) -> {
                Direction facing = (Direction)state.m_61143_((Property)SlidingDoorBlock.f_52726_);
                boolean showAtAll = (Boolean)state.m_61143_((Property)SlidingDoorBlock.VISIBLE) != false && (Boolean)state.m_61143_((Property)SlidingDoorBlock.f_52727_) == false;
                return showAtAll && (d == facing || d == facing.m_122424_());
            });
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        protected Vec3 getLocalOffset(BlockState state) {
            Vec3 location = VecHelper.voxelSpace((double)8.0, (double)8.0, (double)(state.m_61143_((Property)SlidingDoorBlock.f_52726_) == this.direction ? 3.0 : 16.0));
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.verticalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.X);
            return location;
        }
    }
}

